(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to Block/Release/Clear/Check Status of motion buffer Xbot.
 * If XbotID = 0 (All), BufferOption 3 is not valid.
 * 
 *Input:
 * MsgFrame  (Profinet output frame)
 * ReadFrame (Profinet reply frame)
 * Execute   (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label (Optional 2 byte Command label. Used to identify specfic commands.
 * Xbot ID   (0 means all, any positive integer represent a particular Xbot.
 * BufferOption (0 = Block buffer, 1 = Release Buffer, 2 = Clear Buffer, 3 = Get motion buffer status)
 *
 * Output:
 * Error (Indicates if there is an error)
 * Busy  (FuB will be Busy until reply)
 * Done  (When Accepted command is received, Done = TRUE)
 * BufferStatus (0 = Unblocked, 1 = Blocked)
 * NumOfCmd (Number of motion commands in buffer)
 * FirstCmdLbl  (Cmd label of the first motion command in the buffer. = 0xFFFE if buffer is empty)
 * FinalCmdLbl  (Cmd label of the first motion command in the buffer. = 0xFFFE if buffer is empty)
 * ErrorID (0x0001 = System Error, 0x2000 = Wrong PMC State, 0x2001 = No Mastership, 0x2002 = Mastership timeout,
 *		    0x2003 = Wrong group state, 0x2004 = Wrong Macro state, 0x2005 = Wrong Digital IO state,
 *          0x2006 = Wrong flyways state, 0x3000 = Wrong Xbot state, 0x4000 = Paramter Error: Invalid Parameters.
 *********************************************************************************)






FUNCTION_BLOCK PM_MotionBuffer		
	// Check Reply
	IF(Busy)THEN
		brsmemcpy(ADR(CmdLbl),ADR(ReadFrame[3]),2);
		IF(ReadFrame[0] = CmdCount AND
			ReadFrame[1] 	= 21  AND
			ReadFrame[2]	= 11 AND
			CmdLbl = CmdLabel)THEN
			Done 	:= TRUE;
			Busy 	:= FALSE;
			brsmemcpy(ADR(ErrorID),ADR(ReadFrame[5]),2);
			Error 	:= UINT_TO_BOOL(ErrorID);
			Done 	:= NOT(UINT_TO_BOOL(ErrorID));
			BufferStatus := ReadFrame[8];
			brsmemcpy(ADR(NumOfCmd),ADR(ReadFrame[9]),2);
			brsmemcpy(ADR(FirstCmdLbl),ADR(ReadFrame[11]),2);
			brsmemcpy(ADR(FinalCmdLbl),ADR(ReadFrame[13]),2);
			
		ELSE
			Busy := FALSE;
		END_IF;
	END_IF;
	//Send Command		
	IF(Execute AND NOT(Done) AND NOT(Error))THEN
		IF(NOT(Busy))THEN
			brsmemset(ADR(MsgFrame[1]),FALSE,98);
			CmdCount 		:= ReadFrame[0] +1;
			MsgFrame[0] 	:= CmdCount; 
			MsgFrame[1] 	:= 21;
			MsgFrame[2] 	:= 11;
			brsmemcpy(ADR(MsgFrame[3]), ADR(CmdLabel), 2);
			MsgFrame[5]		:= 1;
			MsgFrame[6]		:= BufferOption;
			MsgFrame[9] 	:= XbotID;
			Busy := TRUE;	
		END_IF;
		
	//Reset output status
	ELSIF(NOT(Execute))THEN
		Busy := FALSE;
		Done := FALSE;
		Error := FALSE;
		ErrorID := 0;
	END_IF
	
	
	
END_FUNCTION_BLOCK
